# Signature Pad
SignaturePad: A jQuery plugin for assisting in the creation of an HTML5 canvas based signature pad. Records the drawn signature in JSON for later regeneration.

Copyright MMXI, Thomas J Bradley, <hey@thomasjbradley.ca>

Dependencies: FlashCanvas/1.5, json2.js, jQuery/1.3.2+

Versioned using Semantic Versioning, <http://semver.org/>

## Quick Start
1. Include `jquery.signaturepad.css`, `flashcanvas.js`, `jquery.js`, `jquery.signaturepad.js`, `json2.js` in your HTML file
2. Create the HTML, following the example: <https://github.com/thomasjbradley/signature-pad/blob/master/examples/accept-signature.html>
3. `$('.sigPad').signaturePad();`
4. Remember that [most things are configurable](http://thomasjbradley.ca/lab/signature-pad#options)

## Complete Documentation
<http://thomasjbradley.ca/lab/signature-pad>

## Examples
- [Accepting a Signature](https://github.com/thomasjbradley/signature-pad/blob/master/examples/accept-signature.html)
- [Requiring a Drawn Signature](https://github.com/thomasjbradley/signature-pad/blob/master/examples/require-drawn-signature.html)
- [Regenerating a Signature](https://github.com/thomasjbradley/signature-pad/blob/master/examples/regenerate-signature.html)
- [Accepting Multiple Signatures](https://github.com/thomasjbradley/signature-pad/blob/master/examples/accept-multiple-signatures.html)

## Demos
- [Accepting a Signature](http://thomasjbradley.ca/lab/signature-pad-accept)
- [Requiring a Drawn Signature](http://thomasjbradley.ca/lab/signature-pad-require-drawn)
- [Regenerating a Signature](http://thomasjbradley.ca/lab/signature-pad-regenerate)

## Converting to an Image
<http://thomasjbradley.ca/lab/signature-pad/#images>

## Source Code
<http://github.com/thomasjbradley/signature-pad>

## License
Signature Pad is licensed under the [New BSD license](https://github.com/thomasjbradley/signature-pad/blob/master/NEW-BSD-LICENSE.txt).

All dependencies: jQuery, json2.js, and FlashCanvas retain their own licenses.
